/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: U4AAPI.cpp                                                         *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
* Carlos Grossy              05/04/2007       1.1                              *
*******************************************************************************/

#include "U4AAPI.h"
#include "USBTrans.h"
#include "CommandLayer.h"
#include "HandlerLayer.h"
#include "Log.h"

u4a* u4a::instance = 0;
bool u4a::borrado = false;

u4a::u4a() {

    l = log::instance();
    hl = new handlerLayer();
    cl = new commandLayer(hl);
}

u4a::~u4a() {

    if (!u4a::borrado) {
        u4a::instance->l->printLog("u4a destructor",true,true);
        delete u4a::instance->cl;
        delete u4a::instance->hl;
        delete u4a::instance->l;
        u4a::borrado = true;
        delete u4a::instance;
    }
}

u4a* u4a::getInstance(){

    if ( u4a::instance == 0 ) {
        u4a::instance = new u4a();
    }
    return u4a::instance;
}

int * u4a::getU4ABoards(int &cant) {

    u4a *u4aTemp = u4a::getInstance();
    return (u4aTemp->hl->getU4ABoards(cant));
}

int u4a::getSerialNumber(int n) {

    u4a *u4aTemp = u4a::getInstance();
    int cant;
    int *temp = u4aTemp->hl->getU4ABoards(cant);
    return (temp[n]);
}

int u4a::openDevice (int serial, char *disp , int ein, int eout) {

    u4a *u4aTemp = u4a::getInstance();
    int id = u4aTemp->cl->open(serial, disp, (usbin) ein, (usbout) eout);
    return id;
}

bool u4a::configDevice (int id, char *dconf) {

    u4a::getInstance();
    return true;
}

bool u4a::sendData (int id, char *dsend, int len, int timeout) {

    u4a *u4atemp = u4a::getInstance();
    bool ok;

    if (u4atemp->hl->existsEntry(id)) {
        ok = u4atemp->hl->send(id, dsend, len, timeout);
        return ok;
    }
    else {
        return false;
    };
}

bool u4a::receiveData (int id, char *drec, int len, int timeout) {

    u4a * u4atemp = u4a::getInstance();
    char *temp;
    bool ok;

    if (u4atemp->hl->existsEntry(id)) {
        temp = u4atemp->hl->receive(id, ok, len, timeout);
        if (ok) {
            for (int i = 0; i < len ; i++)
                drec[i] = temp[i];
            delete [] temp;
            return true;
        }
        else {
            return false;
        }
    }
    else {
        return false;
    }
}

bool u4a::closeDevice (int id) {

    u4a *u4atemp = u4a::getInstance();
    return (u4atemp->cl->close(id));
}

int u4a::apiVersion () {

    return 1;
}

int u4a::firmwareVersion () {

    return 7;
}
